/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.fabrictailor.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.samo_lego.config2brigadier.IBrigadierConfigurator;
import org.samo_lego.config2brigadier.annotation.BrigadierDescription;
import org.samo_lego.config2brigadier.annotation.BrigadierExcluded;
import org.samo_lego.fabrictailor.FabricTailor;

public class TailorConfig
implements IBrigadierConfigurator {
    private static final Gson gson = new GsonBuilder().serializeNulls().setPrettyPrinting().disableHtmlEscaping().create();
    @SerializedName(value="// Whether to allow players to have capes. WARNING! This will toggle ALL capes!")
    public final String _comment_allowCapes = "(default: true)";
    @BrigadierDescription(defaultOption="true")
    @SerializedName(value="allow_capes")
    public boolean allowCapes = true;
    @SerializedName(value="// Default skin for new players. Use command `/fabrictailor setDefaultSkin` to set those values.")
    public final String _comment_defaultSkin = "";
    @SerializedName(value="default_skin")
    public DefaultSkin defaultSkin = new DefaultSkin();
    @SerializedName(value="// How quickly can player change the skin, in seconds. -1 for no limit. If using this in server environment, -1 is not recommended.")
    public final String _comment_skinChangeTimer = "(default in singleplayer: -1, default for server: 60)";
    @BrigadierDescription(defaultOption="-1")
    @SerializedName(value="skin_change_timer")
    public long skinChangeTimer = -1L;

    public void save() {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(FabricTailor.configFile), StandardCharsets.UTF_8);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            FabricTailor.errorLog("Problem occurred when saving config: " + e.getMessage());
        }
    }

    public static TailorConfig loadConfigFile(File file, boolean serverEnvironment) {
        TailorConfig config = null;
        if (file.exists()) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                config = (TailorConfig)gson.fromJson((Reader)fileReader, TailorConfig.class);
            }
            catch (IOException e) {
                FabricTailor.errorLog("fabrictailor Problem occurred when trying to load config: " + e.getMessage());
            }
        }
        if (config == null) {
            config = new TailorConfig();
            if (serverEnvironment) {
                config.skinChangeTimer = 60L;
            } else {
                config.defaultSkin.applyToAll = true;
            }
        }
        config.save();
        return config;
    }

    public static class DefaultSkin {
        @SerializedName(value="// Whether to apply the default skin to ALL new players, not just those without skin.")
        public final String _comment_applyToAll = "(default: false)";
        @BrigadierDescription(defaultOption="false")
        @SerializedName(value="apply_to_all")
        public boolean applyToAll = false;
        @BrigadierExcluded
        public String value = "";
        @BrigadierExcluded
        public String signature = "";
    }
}

